/****** Object:  View [dbo].[V_PAINEL_NFE_ENTRADA_QTDE]    Script Date: 17/11/2018 11:00:00 ******/ 
IF EXISTS (SELECT * 
           FROM   SYS.VIEWS 
           WHERE  OBJECT_ID = 
      Object_id(N'[dbo].[V_PAINEL_NFE_ENTRADA_QTDE]')) 
  DROP VIEW [dbo].[V_PAINEL_NFE_ENTRADA_QTDE] 

GO 
CREATE VIEW V_PAINEL_NFE_ENTRADA_QTDE
AS  
SELECT SUM(QTDE_NFE_ENT_PENDENTE_EMISSAO) AS QTDE_NFE_PENDENTE_EMISSAO ,
       SUM(QTDE_NFE_ENT_NAO_VALIDADA) AS QTDE_NFE_NAO_VALIDADA ,
       SUM(QTDE_NFE_ENT_PENDENTE_SOLUCAO) AS QTDE_NFE_PENDENTE_SOLUCAO ,
       SUM(QTDE_NFE_ENT_VALIDADA) AS QTDE_NFE_VALIDADA ,
       SUM(QTDE_NFE_ENT_CANCELADA) AS QTDE_NFE_CANCELADA ,
       SUM(A_EMITIR) AS A_EMITIR,
       SUM(A_PROCESSAR) AS A_PROCESSAR ,
       SUM(A_ENVIAR) AS A_ENVIAR ,
       SUM(A_RETORNAR) AS A_RETORNAR ,
       SUM(A_GRAVAR) AS A_GRAVAR,
       SUM(TOTAL_PEND) AS TOTAL_PEND
FROM
  (SELECT COUNT(1) AS QTDE_NFE_ENT_PENDENTE_EMISSAO ,
          0 AS QTDE_NFE_ENT_NAO_VALIDADA ,
          0 AS QTDE_NFE_ENT_PENDENTE_SOLUCAO ,
          0 AS QTDE_NFE_ENT_VALIDADA ,
          0 AS QTDE_NFE_ENT_CANCELADA ,
          0 AS A_EMITIR ,
          0 AS A_PROCESSAR ,
          0 AS A_ENVIAR ,
          0 AS A_RETORNAR ,
          0 AS A_GRAVAR ,
          0 AS TOTAL_PEND
   FROM V_EST_NF_NFE_PENDENTE_EMISSAO
   WHERE TIPO_NF = 0
     AND PEND_SOLUC = 0
   UNION ALL SELECT 0 AS QTDE_NFE_ENT_PENDENTE_EMISSAO ,
                    COUNT(DISTINCT EST_NFE_LOTE_ENT.CD_NF) AS QTDE_NFE_ENT_NAO_VALIDADA ,
                    0 AS QTDE_NFE_ENT_PENDENTE_SOLUCAO ,
                    0 AS QTDE_NFE_ENT_VALIDADA ,
                    0 AS QTDE_NFE_ENT_CANCELADA ,
                    0 AS A_EMITIR ,
                    0 AS A_PROCESSAR ,
                    0 AS A_ENVIAR ,
                    0 AS A_RETORNAR ,
                    0 AS A_GRAVAR,
                    0 AS TOTAL_PEND
   FROM EST_NFE_LOTE_ENT
   INNER JOIN EST_NF_ENT ON EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT.CD_EMP
   AND EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT.CD_FILIAL
   AND EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT.CD_NF
   INNER JOIN EST_NFE_LOTE ON EST_NFE_LOTE_ENT.CD_NFE_LOTE = EST_NFE_LOTE.CD_NFE_LOTE
   INNER JOIN GLB_USU ON EST_NFE_LOTE.CD_USU = GLB_USU.CD_USU
   LEFT OUTER JOIN EST_NF_ENT_NFE_PEND ON EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT_NFE_PEND.CD_EMP
   AND EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT_NFE_PEND.CD_FILIAL
   AND EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT_NFE_PEND.CD_NF
   LEFT OUTER JOIN EST_NF_ENT_NFE ON EST_NFE_LOTE_ENT.CD_EMP = EST_NF_ENT_NFE.CD_EMP
   AND EST_NFE_LOTE_ENT.CD_FILIAL = EST_NF_ENT_NFE.CD_FILIAL
   AND EST_NFE_LOTE_ENT.CD_NF = EST_NF_ENT_NFE.CD_NF
   WHERE EST_NFE_LOTE_ENT.CD_EMP =1
     AND EST_NF_ENT.DT_EMI_NF >= CONVERT(CHAR(10), GETDATE()-7, 112)
     AND EST_NF_ENT_NFE_PEND.CD_NF IS NULL
     AND EST_NF_ENT_NFE.CD_NF IS NULL
     AND EST_NF_ENT.STS_NF = 0
   UNION ALL SELECT 0 AS QTDE_NFE_ENT_PENDENTE_EMISSAO ,
                    0 AS QTDE_NFE_ENT_NAO_VALIDADA ,
                    COUNT(1) AS QTDE_NFE_ENT_PENDENTE_SOLUCAO ,
                    0 AS QTDE_NFE_ENT_VALIDADA ,
                    0 AS QTDE_NFE_ENT_CANCELADA ,
                    0 AS A_EMITIR ,
                    0 AS A_PROCESSAR ,
                    0 AS A_ENVIAR ,
                    0 AS A_RETORNAR ,
                    0 AS A_GRAVAR,
                    0 AS TOTAL_PEND
   FROM V_EST_NF_NFE_PENDENTE_EMISSAO
   WHERE TIPO_NF IN (0,
                     3)
     AND PEND_SOLUC = 1
   UNION ALL SELECT 0 AS QTDE_NFE_ENT_PENDENTE_EMISSAO ,
                    0 AS QTDE_NFE_ENT_NAO_VALIDADA ,
                    0 AS QTDE_NFE_ENT_PENDENTE_SOLUCAO ,
                    COUNT(1) AS QTDE_NFE_ENT_VALIDADA ,
                    0 AS QTDE_NFE_ENT_CANCELADA ,
                    0 AS A_EMITIR ,
                    0 AS A_PROCESSAR ,
                    0 AS A_ENVIAR ,
                    0 AS A_RETORNAR ,
                    0 AS A_GRAVAR,
                    0 AS TOTAL_PEND
   FROM EST_NF_ENT NF
   INNER JOIN EST_NF_SERIE SERIE ON NF.CD_NF_SERIE = SERIE.CD_NF_SERIE
   AND SERIE.ESPC = 'NFE'
   INNER JOIN EST_NF_ENT_NFE NFE ON NF.CD_EMP = NFE.CD_EMP
   AND NF.CD_FILIAL = NFE.CD_FILIAL
   AND NF.CD_NF = NFE.CD_NF
   WHERE NF.DT_ENT = CONVERT(CHAR(10), GETDATE(), 112)
     AND NFE.NR_PROTOCOLO IS NOT NULL
     AND NFE.NR_AUTORIZADOR IS NOT NULL
   UNION ALL SELECT 0 AS QTDE_NFE_ENT_PENDENTE_EMISSAO ,
                    0 AS QTDE_NFE_ENT_NAO_VALIDADA ,
                    0 AS QTDE_NFE_ENT_PENDENTE_SOLUCAO ,
                    0 AS QTDE_NFE_ENT_VALIDADA ,
                    COUNT(1) AS QTDE_NFE_ENT_CANCELADA ,
                    0 AS A_EMITIR ,
                    0 AS A_PROCESSAR ,
                    0 AS A_ENVIAR ,
                    0 AS A_RETORNAR ,
                    0 AS A_GRAVAR,
                    0 AS TOTAL_PEND
   FROM EST_NF_ENT_NFE_CANCEL
   WHERE EST_NF_ENT_NFE_CANCEL.CD_EMP =1
     AND EST_NF_ENT_NFE_CANCEL.DT_CAD >= CONVERT(CHAR(10), GETDATE(), 112)
   UNION ALL SELECT 0 AS QTDE_NFE_SAI_PENDENTE_EMISSAO ,
                    0 AS QTDE_NFE_SAI_NAO_VALIDADA ,
                    0 AS QTDE_NFE_SAI_PENDENTE_SOLUCAO ,
                    0 AS QTDE_NFE_SAI_VALIDADA ,
                    0 AS QTDE_NFE_SAI_CANCELADA ,
                    A_EMITIR ,
                    A_PROCESSAR ,
                    A_ENVIAR ,
                    A_RETORNAR ,
                    A_GRAVAR ,
                    TOTAL_PEND
   FROM V_NFE_STATUS
   WHERE TIPO = 'ENTRADA' ) RS


